
/**
  Smart Irrigation System using the Arduino Edge Control - Application Note
  Name: MKR_WAN_Code.ino
  Purpose: 4 Zones Smart Irrigation System using the Arduino Edge Control with Cloud connectivity using a MKR WAN 1310.
  @author Christopher Mendez
*/

#include "arduino_secrets.h"
#include "thingProperties.h"
#include "SensorValues.hpp"
#include <Wire.h>

#include <ArduinoJson.h>

// The MKR1 board I2C address
#define SELF_I2C_ADDR 0x05

unsigned long previousMillis = 0;
const long interval = 3*60000;  //180 second interval (3 minutes)

/**
  Main section setup
*/
void setup() {
  // Initialize serial and wait for port to open:
  Serial.begin(115200);
  // This delay gives the chance to wait for a Serial Monitor without blocking if none is found
  delay(1500);

  // Defined in thingProperties.h
  initProperties();

  // Connect to Arduino IoT Cloud
  ArduinoCloud.begin(ArduinoIoTPreferredConnection, false);

  /*
     The following function allows you to obtain more information
     related to the state of network and IoT Cloud connection and errors
     the higher number the more granular information you’ll get.
     The default is 0 (only errors).
     Maximum is 4
 */
  setDebugMessageLevel(2);
  ArduinoCloud.printDebugInfo();

    // Init I2C coomunication
  Wire.begin(SELF_I2C_ADDR);
  Wire.onReceive(receiveEvent);  // I2C receive callback

}

/**
 Main section loop
*/
void loop() {

  ArduinoCloud.update();

}

/**
  Function that handles when the Edge Control sends data to the MKR.
  @param bytes The I2C communicated sensors raw values
*/
void receiveEvent(int bytes) {
  uint8_t buf[200];
  uint8_t *ptr = &buf[0];

  SensorValues_t *vals;

  Serial.println("Receive event");

  while (Wire.available() > 0) {
    *ptr = Wire.read();
    ptr++;
  }

  vals = (SensorValues_t *)buf;

  uploadValues(vals);
}

/**
  Function that updates the Arduino Cloud variables with local values and those received from the Edge Control
  @param vals includes the structured values of the shared variables
*/
void uploadValues(SensorValues_t *vals) {

  StaticJsonDocument<200> doc;
  doc["Zone 1"] = vals->valve1_local;
  doc["Zone 2"] = vals->valve2_local;
  doc["Zone 3"] = vals->valve3_local;
  doc["Zone 4"] = vals->valve4_local;
  doc["Moisture 1"] = vals->z1_moisture_local;
  doc["Moisture 2"] = vals->z2_moisture_local;
  doc["Moisture 3"] = vals->z3_moisture_local;
  doc["Moisture 4"] = vals->z4_moisture_local;
  doc["Water usage"] = vals->water_usage_local;

  String output;
  serializeJson(doc, output);
  Serial.println(output);

  // Cloud variable --- Shared I2C Variable
  water_usage = vals->water_usage_local;  
  water_flow = vals->water_flow_local;

  z1_on_time = vals->z1_on_time_local;
  z2_on_time = vals->z2_on_time_local;
  z3_on_time = vals->z3_on_time_local;
  z4_on_time = vals->z4_on_time_local;

  z1_moisture = vals->z1_moisture_local;
  z2_moisture = vals->z2_moisture_local;
  z3_moisture = vals->z3_moisture_local;
  z4_moisture = vals->z4_moisture_local;

  valve1 = vals->valve1_local;
  valve2 = vals->valve2_local;
  valve3 = vals->valve3_local;
  valve4 = vals->valve4_local;

  battery_volt = vals->battery_volt_local;

}